// NvsInfo.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "NvsInfo.h"
#include "Include/CommonFun.h"
#include "Include/CLS_NVDSDK_Interface.h"

#define MAX_DEMO_RTSP_URL_LEN	DEC_LEN_256

const int CONST_INT_NORMAL_PORT = 3000;
const int CONST_INT_ONVIF_PORT = 80;

// CNvsInfo dialog

IMPLEMENT_DYNAMIC(CNvsInfo, CDialog)

CNvsInfo::CNvsInfo(CWnd* pParent /*=NULL*/)
	: CDialog(CNvsInfo::IDD, pParent)
{
	m_ptNvsItem = NULL;
	m_iID = -1;
	m_iModify = DLG_STYLE_ADD;

	m_iAlarmType = 0;
	m_iPort = 0;

	m_ptViewServer = NULL;
}

CNvsInfo::~CNvsInfo()
{

}

void CNvsInfo::Init(int _iID, TNVSITEMEX* _ptNvsItem, int _iModify, int _iLogonID)
{
	m_iID = _iID;
    m_ptNvsItem = _ptNvsItem;
	m_iModify = _iModify;
	m_iLogonID = _iLogonID;
}

void CNvsInfo::InitEx(int _iID, ViewServerInfo* _ptNvsView, int _iModify, int _iLogonID)
{
	m_iID = _iID;
	m_ptViewServer = _ptNvsView;
	m_iModify = _iModify;
	m_iLogonID = _iLogonID;
}

void CNvsInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_cboChannel);
	DDX_Control(pDX, IDC_COMBO_STREAMTYPE, m_cboStream);
	DDX_Control(pDX, IDC_COMBO_PROTOCOLTYPE, m_cboDeviceType);
	DDX_Control(pDX, IDC_COMBO_NETMODE, m_cboNetMode);
	DDX_Control(pDX, IDC_COMBO_CONNECT_MODE, m_cboConnectMode);
	DDX_Control(pDX, IDC_COMBO_DEVPLATTYPE,	m_cboDevPlatType);
	DDX_Control(pDX, IDC_CBO_CHANNEL_NUM, m_cboChannelNum);
	DDX_Control(pDX, IDC_CBO_SCREEN_NUM, m_cboPicNO);
	DDX_Control(pDX, IDC_EDIT_NVSINFO_MULTIP, m_edtNvsInfoMultIP);
	DDX_Control(pDX, IDC_EDIT_NVSINFO_MULTPORT, m_edtNvsInfoMultPort);
}

BEGIN_MESSAGE_MAP(CNvsInfo, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_OK, &CNvsInfo::OnBnClickedButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_CANCEL, &CNvsInfo::OnBnClickedButtonCancel)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NUM, &CNvsInfo::OnCbnSelchangeCboChannelNum)
	ON_CBN_SELCHANGE(IDC_COMBO_DEVPLATTYPE, &CNvsInfo::OnCbnSelchangeComboDevplattype)
END_MESSAGE_MAP()

BOOL CNvsInfo::OnInitDialog()
{
	CDialog::OnInitDialog();

	//ô
	SetDlgItemText(IDC_STC_CHANNEL_NUM,GetText(IDS_ALARM_CHANGE));
	SetDlgItemText(IDC_STC_SCREEN_NUM,GetText(IDS_MAIN_SCREEN));
	SetDlgItemText(IDC_STATIC_SERVERIP,GetText(IDS_MAIN_SERVER_IP));
	SetDlgItemText(IDC_STATIC_PROXYIP,GetText(IDS_MAIN_PROXY_IP));
	SetDlgItemText(IDC_STATIC_CHANNEL,GetText(IDS_MAIN_CHANNEL));
	SetDlgItemText(IDC_STATIC_PORT,GetText(IDS_MAIN_PORT));
	SetDlgItemText(IDC_STATIC_STREAMTYPE,GetText(IDS_MAIN_STREAM));
	SetDlgItemText(IDC_STATIC_PROTOCOLTYPE,GetText(IDS_MAIN_DEVICE_TYPE));
	SetDlgItemText(IDC_STATIC_NETMODE,GetText(IDS_MAIN_NET_MODE));
	SetDlgItemText(IDC_STATIC_ADDRESS,GetText(IDS_MAIN_DEVICE_ADDRESS));
	SetDlgItemText(IDC_STATIC_USERNAME,GetText(IDS_MAIN_USERNAME));
	SetDlgItemText(IDC_STATIC_PASSWORD,GetText(IDS_MAIN_PASSWORD));
	SetDlgItemText(IDC_STATIC_STAYTIME,GetText(IDS_MAIN_HOLD_TIME));
	SetDlgItemText(IDC_STATIC_CONNECT_MODE,GetText(IDS_MAIN_CONNECT_MODE));
	SetDlgItemText(IDC_BUTTON_OK,GetText(IDS_NVS_INFO_OK));
	SetDlgItemText(IDC_BUTTON_CANCEL,GetText(IDS_NVS_INFO_CANCEL));
	SetDlgItemText(IDC_STATIC_ENCRYPTPWD, GetText(IDS_ENCRYPT_PWD));
	SetDlgItemText(IDC_STATIC_DEVPLATTYPE, GetText(IDS_DEV_PLAT_TYPE));
	SetDlgItemText(IDC_STATIC_NVSINFO_MULTIP, GetText(IDS_MULT_IP));
	SetDlgItemText(IDC_STATIC_NVSINFO_MULTPORT, GetText(IDS_MULT_PORT));
	SetDlgItemText(IDC_STATIC_MULT_PORT_WARING, GetText(IDS_MULT_PORT_WARING));

	//볤
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_EDIT_SERVER_IP);
	pEdit->SetLimitText(MAX_DEMO_RTSP_URL_LEN);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PROXY_IP);
	pEdit->SetLimitText(15);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PORT);
	pEdit->SetLimitText(5);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_ADDRESS);
	pEdit->SetLimitText(3);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_USERNAME);
	pEdit->SetLimitText(15);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PASSWORD);
	pEdit->SetLimitText(15);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_STAYTIME);
	pEdit->SetLimitText(4);
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_ENCYPTPWD);//--->bo modify bug20130506
	pEdit->SetLimitText(16);

	//óʼ
	CString strChannel;
	for (int i=1; i<=NVS_MAX_CHANNEL_NUM; ++i)
	{
		strChannel.Format(_T("%d"),i);
		m_cboChannel.AddString(strChannel);
	}

	m_cboStream.AddString(GetText(IDS_MAIN_STREAM_MAIN));
	m_cboStream.AddString(GetText(IDS_MAIN_STREAM_SUB));

	m_cboNetMode.AddString(GetText(IDS_MAIN_NET_MODE_TCP));
	m_cboNetMode.AddString(GetText(IDS_MAIN_NET_MODE_UDP));
	m_cboNetMode.AddString(GetText(IDS_MAIN_NET_MODE_MUT));

	int iIndex = m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_IP));
	m_cboConnectMode.SetItemData(iIndex, CONNECT_MODE_IP);
	iIndex = m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_DDNS));
	m_cboConnectMode.SetItemData(iIndex, CONNECT_MODE_DDNS);
	iIndex = m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_DSM));
	m_cboConnectMode.SetItemData(iIndex, CONNECT_MODE_DSM);

	m_edtNvsInfoMultIP.SetLimitText(64);
	m_edtNvsInfoMultPort.SetLimitText(16);

	m_edtNvsInfoMultIP.SetWindowText("224.0.0.0");
	SetDlgItemInt(IDC_EDIT_NVSINFO_MULTPORT, 20000);

	if (DLG_STYLE_ADD == m_iModify)
	{
		SetWindowText(GetText(IDS_MAIN_ADD_SERVER));

		InitInfoNormal();
	}
	else if (DLG_STYLE_MODIFY == m_iModify)
	{
		SetWindowText(GetText(IDS_MAIN_MODIFY_SERVER));

		InitInfoNormal();
	}
	else if (DLG_STYLE_SET == m_iModify)
	{
		SetWindowText(GetText(IDS_ALARM_LINK_CHANGE_SET));
		
		InitInfoSetAlarmlink();
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

void CNvsInfo::OnBnClickedButtonOk()
{
	int iRet = -1;
	if (DLG_STYLE_SET == m_iModify)
	{
		iRet = SetAlarmLinkSwitch();
	}
	else
	{
		iRet = ProcessVideoServerInfo();
	}

	if (iRet != 0)
	{
		return;
	}

	OnOK();
}

void CNvsInfo::OnBnClickedButtonCancel()
{
	OnCancel();
}

void CNvsInfo::InitPicNum(int _iChannel)
{
	m_cboPicNO.ResetContent();
	int iMode = 0;

	ChannelPicNum tPicNum = {0};
	tPicNum.iSize = sizeof(ChannelPicNum);

	int iRet = DEC_ClientGetDevConfig(m_iLogonID, _iChannel, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
	if (ERR_SUCCESS == iRet)
	{
		iMode = tPicNum.iPicNum;
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::GetScreenInfo] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_PICNUM);
	}

	if(iMode < 0 || iMode > DEC_MAX_PICTURE_NUM)
	{
		iMode = 0;
	}
	
	CreatePosCombo(m_iLogonID, GetComboData(&m_cboChannelNum), 0, &m_cboPicNO, 1);//typeʾӿѡ
	m_cboPicNO.EnableWindow(TRUE);
}

void CNvsInfo::OnCbnSelchangeCboChannelNum()
{
	// TODO: Add your control notification handler code here
	int iSel = m_cboChannelNum.GetCurSel();
	int iChannel = m_cboChannelNum.GetItemData(iSel);
	InitPicNum(iChannel);
	UpdateAlarmLinkNvsInfo(iChannel);
}

void CNvsInfo::SetAlarmType(int _iAlarmType, int _iPort /* = 0*/)
{
	m_iAlarmType = _iAlarmType;
	m_iPort = _iPort;
}

void CNvsInfo::InitInfoNormal()
{
	GetDlgItem(IDC_STC_CHANNEL_NUM)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_CBO_CHANNEL_NUM)->ShowWindow(SW_HIDE);

	GetDlgItem(IDC_STC_SCREEN_NUM)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_CBO_SCREEN_NUM)->ShowWindow(SW_HIDE);

	//ȡЭб
	TDECPROTOCOL_EX tProtocolEx = {0};
	int iRet = DEC_ClientGetDevConfig(m_iID, 0, 0, CMD_DEC_CFG_PROTOCOL, &tProtocolEx, sizeof(TDECPROTOCOL_EX));
	if(ERR_SUCCESS == iRet)
	{
		for(int i=0; i<tProtocolEx.m_iCount; i++)
		{
			m_cboDeviceType.AddString((LPCTSTR)(LPCSTR)tProtocolEx.m_cProtocol[i]);
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CNvsInfo::OnInitDialog] Get PTZ protocols Failed! Ret(%d),Error(0x%08x),ID(%d)"
			,m_iID);
	}

	//if (m_ptNvsItem)
	//{
	//	if (DEVTYPE_RTSP == m_ptNvsItem->m_iDevPlatType)
	//	{
	//		SetDlgItemText(IDC_EDIT_SERVER_IP, (LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_cRTSPUrl);			
	//		SetDlgItemText(IDC_EDIT_PROXY_IP, "");
	//	}
	//	else
	//	{
	//		if (m_ptNvsItem->m_stOldItem.m_bUseddns == 0)
	//		{
	//			SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_serIP);
	//		}
	//		else
	//		{
	//			SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_serName);
	//		}
	//		SetDlgItemText(IDC_EDIT_PROXY_IP,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_serProxy);
	//	}

	//	int iDeviceType = m_cboDeviceType.FindStringExact(0,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_deviceType);
	//	if (iDeviceType < 0)
	//	{
	//		m_cboDeviceType.SetCurSel(0);
	//		m_cboDeviceType.SelectString(0, "DOME_PELCO_P");
	//	} 
	//	else
	//	{
	//		m_cboDeviceType.SetCurSel(iDeviceType);
	//	}
	//	SetDlgItemText(IDC_EDIT_USERNAME,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_username);
	//	SetDlgItemText(IDC_EDIT_PASSWORD,(LPCTSTR)(LPCSTR)m_ptNvsItem->m_stOldItem.m_password);
	//	m_cboChannel.SetCurSel(m_ptNvsItem->m_stOldItem.m_serChan);
	//	m_cboStream.SetCurSel(m_ptNvsItem->m_stOldItem.m_serStream);
	//	m_cboNetMode.SetCurSel(m_ptNvsItem->m_stOldItem.m_serNetmode-1);
	//	m_cboConnectMode.SetCurSel(m_ptNvsItem->m_stOldItem.m_bUseddns);
	//	SetDlgItemInt(IDC_EDIT_PORT,m_ptNvsItem->m_stOldItem.m_serPort);
	//	SetDlgItemInt(IDC_EDIT_ADDRESS,m_ptNvsItem->m_stOldItem.m_iAddress);
	//	SetDlgItemInt(IDC_EDIT_STAYTIME,m_ptNvsItem->m_stOldItem.m_holdtime);
	//}

	//int iIndex = m_cboDevPlatType.AddString(_T("Normal"));
	//m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_NORMAL);
	//iIndex = m_cboDevPlatType.AddString(_T("Onvif"));
	//m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ONVIF);
	//iIndex = m_cboDevPlatType.AddString(_T("RTSP"));
	//m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_RTSP);	
	//iIndex = m_cboDevPlatType.AddString(_T("Encode Card"));
	//m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ENCODE);	

	//if (DEVTYPE_RTSP != m_ptNvsItem->m_iDevPlatType && DEVTYPE_ENCODE != m_ptNvsItem->m_iDevPlatType)
	//{
	//	m_cboDevPlatType.SetCurSel(m_ptNvsItem->m_iDevPlatType);
	//}
	//else
	//{
	//	m_cboDevPlatType.SetCurSel(m_ptNvsItem->m_iDevPlatType -1);
	//}	

	//SetDlgItemText(IDC_EDIT_ENCYPTPWD, (LPCTSTR)(LPCSTR)m_ptNvsItem->m_cEncyptPWD);

	//m_edtNvsInfoMultIP.SetWindowText((LPCTSTR)(LPCSTR)m_ptNvsItem->m_cMultIP);
	//SetDlgItemInt(IDC_EDIT_NVSINFO_MULTPORT, m_ptNvsItem->m_iMultPort);


	if (m_ptViewServer == NULL)
	{
		AddLog(LOG_LEVEL_ERROR,"[CNvsInfo::OnInitDialog] m_ptViewServer == NULL!");
		return;
	}

	int iIndex = m_cboDevPlatType.AddString(_T("Normal"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_NORMAL);
	iIndex = m_cboDevPlatType.AddString(_T("Onvif"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ONVIF);
	iIndex = m_cboDevPlatType.AddString(_T("RTSP"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_RTSP);	
	iIndex = m_cboDevPlatType.AddString(_T("Encode Card"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ENCODE);
	iIndex = m_cboDevPlatType.AddString(_T("Local Input"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_LOCAL);
	int iIndexLG = m_cboDevPlatType.AddString(_T("Onvif_LG"));
	m_cboDevPlatType.SetItemData(iIndexLG, DEVTYPE_LG);
	int iIndexPanasonic = m_cboDevPlatType.AddString(_T("Onvif_Panasonic"));
	m_cboDevPlatType.SetItemData(iIndexPanasonic, DEVTYPE_PANASONIC);
	switch (m_ptViewServer->ser_type)
	{
	case DEVTYPE_RTSP:
	case DEVTYPE_ENCODE:
	case DEVTYPE_LOCAL:
		{
			m_cboDevPlatType.SetCurSel(m_ptViewServer->ser_type -1);
		}
		break;
	case DEVTYPE_LG:
		{
			m_cboDevPlatType.SetCurSel(iIndexLG);
		}
		break;
	case DEVTYPE_PANASONIC:
		{
			m_cboDevPlatType.SetCurSel(iIndexPanasonic);
		}
		break;
	default:
		{
			m_cboDevPlatType.SetCurSel(m_ptViewServer->ser_type);
		}
		break;
	}

	if (DEVTYPE_RTSP == m_ptViewServer->ser_type)
	{
		SetDlgItemText(IDC_EDIT_SERVER_IP, (LPCTSTR)(LPCSTR)m_ptViewServer->rtsp_url);			
		SetDlgItemText(IDC_EDIT_PROXY_IP, "");
	}
	else
	{
		if (0 == m_ptViewServer->con_mode)
		{
			SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_ip);
		}
		else
		{
			SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_name);
		}
		SetDlgItemText(IDC_EDIT_PROXY_IP,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_proxy);
	}

	int iDeviceType = m_cboDeviceType.FindStringExact(0,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_ptz_protocol);
	if (iDeviceType < 0)
	{
		m_cboDeviceType.SetCurSel(0);
		m_cboDeviceType.SelectString(0, "DOME_PELCO_P");
	} 
	else
	{
		m_cboDeviceType.SetCurSel(iDeviceType);
	}
	SetDlgItemText(IDC_EDIT_USERNAME,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_usr_name);
	SetDlgItemText(IDC_EDIT_PASSWORD,(LPCTSTR)(LPCSTR)m_ptViewServer->ser_usr_pwd);
	m_cboChannel.SetCurSel(m_ptViewServer->ser_ch_no);
	m_cboStream.SetCurSel(m_ptViewServer->ser_stream_no);
	m_cboNetMode.SetCurSel(m_ptViewServer->ser_net_mode - 1);
	m_cboConnectMode.SetCurSel(m_ptViewServer->con_mode);
	SetDlgItemInt(IDC_EDIT_PORT,m_ptViewServer->ser_port);
	SetDlgItemInt(IDC_EDIT_ADDRESS,m_ptViewServer->ser_ptz_addr);
	SetDlgItemInt(IDC_EDIT_STAYTIME,m_ptViewServer->hold_time);
	SetDlgItemText(IDC_EDIT_ENCYPTPWD, (LPCTSTR)(LPCSTR)m_ptViewServer->video_dec_pwd);
	m_edtNvsInfoMultIP.SetWindowText((LPCTSTR)(LPCSTR)m_ptViewServer->mult_ip);
	SetDlgItemInt(IDC_EDIT_NVSINFO_MULTPORT, m_ptViewServer->mult_port);
}

void CNvsInfo::InitInfoSetAlarmlink()
{	
	GetDlgItem(IDC_COMBO_PROTOCOLTYPE)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_ADDRESS)->EnableWindow(FALSE);

	CreateChannelCombo(m_iLogonID, &m_cboChannelNum);

	int iIndex = m_cboDevPlatType.AddString(_T("Normal"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_NORMAL);
	iIndex = m_cboDevPlatType.AddString(_T("Onvif"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ONVIF);
	iIndex = m_cboDevPlatType.AddString(_T("RTSP"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_RTSP);
	iIndex = m_cboDevPlatType.AddString(_T("Encode Card"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_ENCODE);
	iIndex = m_cboDevPlatType.AddString(_T("Local Input"));
	m_cboDevPlatType.SetItemData(iIndex, DEVTYPE_LOCAL);
	int iIndexLG = m_cboDevPlatType.AddString(_T("Onvif_LG"));
	m_cboDevPlatType.SetItemData(iIndexLG, DEVTYPE_LG);
	int iIndexPanasonic = m_cboDevPlatType.AddString(_T("Onvif_Panasonic"));
	m_cboDevPlatType.SetItemData(iIndexPanasonic, DEVTYPE_PANASONIC);
	switch (m_ptViewServer->ser_type)
	{
	case DEVTYPE_RTSP:
	case DEVTYPE_ENCODE:
	case DEVTYPE_LOCAL:
		{
			m_cboDevPlatType.SetCurSel(m_ptViewServer->ser_type -1);
		}
		break;
	case DEVTYPE_LG:
		{
			m_cboDevPlatType.SetCurSel(iIndexLG);
		}
		break;
	case DEVTYPE_PANASONIC:
		{
			m_cboDevPlatType.SetCurSel(iIndexPanasonic);
		}
		break;
	default:
		{
			m_cboDevPlatType.SetCurSel(m_ptViewServer->ser_type);
		}
		break;
	}

	AlarmLinkSwitch alarmLS = {0};	
	alarmLS.iAlarmType = m_iAlarmType;
	alarmLS.iPortNo = m_iPort;
	bool blHasAlarmChannel = false;
	int iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &alarmLS, sizeof(AlarmLinkSwitch));
	if(ERR_SUCCESS == iRet)
	{
		for(int i = 0; i < m_cboChannelNum.GetCount(); ++i)
		{
			if (alarmLS.iChannelNo == m_cboChannelNum.GetItemData(i))
			{
				m_cboChannelNum.SetCurSel(i);
				InitPicNum(alarmLS.iChannelNo);
				blHasAlarmChannel = true;
				break;
			}
		}

		if (!blHasAlarmChannel)
		{
			InitPicNum(0);
		}

		for(int i = 0; i < m_cboPicNO.GetCount(); ++i)
		{
			if (alarmLS.iPos == m_cboPicNO.GetItemData(i))
			{
				m_cboPicNO.SetCurSel(i);
				break;
			}
		}

		if (DEVTYPE_RTSP == alarmLS.iSerType)
		{
			SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cRtspUrl);
		}
		else
		{
			if (alarmLS.iUseddns == 0)		
			{
				SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerIP);
			}
			else
			{
				SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerName);
			}
		}
		
		SetDlgItemText(IDC_EDIT_PROXY_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerProxy);

		CString strName(alarmLS.cUserName);
		if (strName != "")
		{
			SetDlgItemText(IDC_EDIT_USERNAME,(LPCTSTR)(LPCSTR)alarmLS.cUserName);
		}
		else
		{
			SetDlgItemText(IDC_EDIT_USERNAME,"Admin");
		}
		
		CString strPwd(alarmLS.cPassword);
		if (strPwd != "")
		{
			SetDlgItemText(IDC_EDIT_PASSWORD,(LPCTSTR)(LPCSTR)alarmLS.cPassword);
		}
		else
		{
			SetDlgItemText(IDC_EDIT_PASSWORD,"1111");
		}

		m_cboChannel.SetCurSel(alarmLS.iSerChan);
		m_cboStream.SetCurSel(alarmLS.iSerStreamNo);

		if (alarmLS.iSerNetmode == 0)
		{
			alarmLS.iSerNetmode = 1;
		}
		m_cboNetMode.SetCurSel(alarmLS.iSerNetmode - 1);

		for (int i=0; i < m_cboConnectMode.GetCount(); i++)
		{
			if (m_cboConnectMode.GetItemData(i) == alarmLS.iUseddns)
			{
				m_cboConnectMode.SetCurSel(i);
			}
		}

		if (alarmLS.iSerPort == 0)
		{
			alarmLS.iSerPort = 3000;
		}
		SetDlgItemInt(IDC_EDIT_PORT,alarmLS.iSerPort);

		if (alarmLS.iHoldTime == 0)
		{
			alarmLS.iHoldTime = 20;
		}
		SetDlgItemInt(IDC_EDIT_STAYTIME,alarmLS.iHoldTime);
		
		int iSel = alarmLS.iSerType;
		if(iSel > DEVTYPE_PUSH)
		{
			iSel--;
		}
		m_cboDevPlatType.SetCurSel(iSel);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CNvsInfo::InitInfoSetAlarmlink] Get AlarmLink Failed! Ret(%d),Error(0x%08x),ID(%d)",m_iLogonID);
		
		//ȡʧʱʹĬֵ
		SetDlgItemText(IDC_EDIT_USERNAME,"Admin");
		SetDlgItemText(IDC_EDIT_PASSWORD,"1111");
		m_cboChannel.SetCurSel(0);
		m_cboStream.SetCurSel(0);
		m_cboNetMode.SetCurSel(0);
		m_cboConnectMode.SetCurSel(0);
		SetDlgItemInt(IDC_EDIT_PORT,3000);
		SetDlgItemInt(IDC_EDIT_STAYTIME,20);
		m_cboDevPlatType.SetCurSel(0);
	}
}

void CNvsInfo::UpdateAlarmLinkNvsInfo(int _iChannelNo)
{
	AlarmLinkSwitch alarmLS = {0};	
	alarmLS.iAlarmType = m_iAlarmType;
	alarmLS.iPortNo = m_iPort;
	int iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &alarmLS, sizeof(AlarmLinkSwitch));
	if(ERR_SUCCESS == iRet)
	{
		if (_iChannelNo == alarmLS.iChannelNo)
		{
			if (DEVTYPE_RTSP == alarmLS.iSerType)
			{
				SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cRtspUrl);
			}
			else
			{
				if (alarmLS.iUseddns == 0)		
				{
					SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerIP);
				}
				else
				{
					SetDlgItemText(IDC_EDIT_SERVER_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerName);
				}
			}

			SetDlgItemText(IDC_EDIT_PROXY_IP,(LPCTSTR)(LPCSTR)alarmLS.cSerProxy);

			CString strName(alarmLS.cUserName);
			if (strName != "")
			{
				SetDlgItemText(IDC_EDIT_USERNAME,(LPCTSTR)(LPCSTR)alarmLS.cUserName);
			}
			else
			{
				SetDlgItemText(IDC_EDIT_USERNAME,"Admin");
			}

			CString strPwd(alarmLS.cPassword);
			if (strPwd != "")
			{
				SetDlgItemText(IDC_EDIT_PASSWORD,(LPCTSTR)(LPCSTR)alarmLS.cPassword);
			}
			else
			{
				SetDlgItemText(IDC_EDIT_PASSWORD,"1111");
			}

			m_cboChannel.SetCurSel(alarmLS.iSerChan);
			m_cboStream.SetCurSel(alarmLS.iSerStreamNo);

			if (alarmLS.iSerNetmode == 0)
			{
				alarmLS.iSerNetmode = 1;
			}
			m_cboNetMode.SetCurSel(alarmLS.iSerNetmode - 1);

			for (int i=0; i < m_cboConnectMode.GetCount(); i++)
			{
				if (m_cboConnectMode.GetItemData(i) == alarmLS.iUseddns)
				{
					m_cboConnectMode.SetCurSel(i);
				}
			}

			if (alarmLS.iSerPort == 0)
			{
				alarmLS.iSerPort = CONST_INT_NORMAL_PORT;
			}
			SetDlgItemInt(IDC_EDIT_PORT,alarmLS.iSerPort);

			if (alarmLS.iHoldTime == 0)
			{
				alarmLS.iHoldTime = 20;
			}
			SetDlgItemInt(IDC_EDIT_STAYTIME,alarmLS.iHoldTime);

			m_cboDevPlatType.SetCurSel(alarmLS.iSerType);
		}
		else
		{
			SetDlgItemText(IDC_EDIT_USERNAME,"Admin");
			SetDlgItemText(IDC_EDIT_PASSWORD,"1111");
			m_cboChannel.SetCurSel(0);
			m_cboStream.SetCurSel(0);
			m_cboNetMode.SetCurSel(0);
			m_cboConnectMode.SetCurSel(0);
			SetDlgItemInt(IDC_EDIT_PORT,CONST_INT_NORMAL_PORT);
			SetDlgItemInt(IDC_EDIT_STAYTIME,20);
			m_cboDevPlatType.SetCurSel(0);
			SetDlgItemText(IDC_EDIT_SERVER_IP, "");
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CNvsInfo::UpdateAlarmLinkNvsInfo] Get AlarmLink Failed! Ret(%d),Error(0x%08x),ID(%d)",m_iLogonID);
	}
}

int CNvsInfo::CheckInvalidIp(int _iConnetMode, CString _cstrIp)
{
	int iRet = 0;
	switch(_iConnetMode)
	{
	case 0: //ip
		{
			if (_cstrIp != "")
			{
				if(IsValidIP((LPSTR)(LPCTSTR)_cstrIp) != 1)
				{
					MessageBox(GetText(IDS_MAIN_INVALID_IP),_T(""),MB_OK|MB_TOPMOST);
					GetDlgItem(IDC_EDIT_SERVER_IP)->SetFocus();
					iRet = -1;
				}
				break;
			}	
		}
	case 1: //ddns
		{
			if(_cstrIp.IsEmpty())
			{
				MessageBox(GetText(IDS_NVS_INFO_INVALID_DDNS),_T(""),MB_OK|MB_TOPMOST);
				GetDlgItem(IDC_EDIT_SERVER_IP)->SetFocus();
				iRet = -1;
			}
			break;
		}
	case 2: //dsm
		{
			if(_cstrIp.IsEmpty() || _cstrIp.GetLength() != 24 || _cstrIp.Left(2).Compare(_T("ID")) != 0)
			{
				MessageBox(GetText(IDS_NVS_INFO_INVALID_DSM),_T(""),MB_OK|MB_TOPMOST);
				GetDlgItem(IDC_EDIT_SERVER_IP)->SetFocus();
				iRet = -1;
			}
			break;
		}
	default:
		{
			AddLog(LOG_LEVEL_WARN,"invalid connect mode! (%d)", _iConnetMode);
			iRet = -1;
		}
	}

	return iRet;
}

int CNvsInfo::SetAlarmLinkSwitch()
{
	int iRet = -1;
	CString strServerIP,strProxyIP,strDeviceType,strUser,strPwd;
	CString strEncyptPWD;
	AlarmLinkSwitch alarmLS = {0};
	int iConnectMode = m_cboConnectMode.GetCurSel();
	GetDlgItemText(IDC_EDIT_SERVER_IP,strServerIP);//--------------->>ȡServerIP
	strServerIP = strServerIP.Trim();

	int iIndex = m_cboDevPlatType.GetCurSel();
	int iDevType = m_cboDevPlatType.GetItemData(iIndex);
	if (iDevType != DEVTYPE_ENCODE && iDevType != DEVTYPE_RTSP)		//RTSP
	{
		iRet = CheckInvalidIp(iConnectMode, strServerIP);
		if (iRet < 0)
		{
			goto END;
		}
	}

	GetDlgItemText(IDC_EDIT_PROXY_IP,strProxyIP);
	strProxyIP = strProxyIP.Trim();
	if (!strProxyIP.IsEmpty() && IsValidIP((LPSTR)(LPCTSTR)strProxyIP) != 1)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PROXY_IP),_T(""),MB_OK|MB_TOPMOST);
		GetDlgItem(IDC_EDIT_PROXY_IP)->SetFocus();
		iRet = -1;
		goto END;
	}

	int iPort = GetDlgItemInt(IDC_EDIT_PORT);
	if((iPort < MIN_SERVER_PORT) || (iPort > MAX_SERVER_PORT))
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PORT),_T(""),MB_OK|MB_TOPMOST);
		GetDlgItem(IDC_EDIT_PORT)->SetFocus();
		iRet = -1;
		goto END;
	}

	int iAddress = GetDlgItemInt(IDC_EDIT_ADDRESS);

	GetDlgItemText(IDC_EDIT_USERNAME,strUser);
	strUser = strUser.Trim();
	if (strUser.IsEmpty())
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_USERNAME),_T(""),MB_OK|MB_TOPMOST);
		GetDlgItem(IDC_EDIT_USERNAME)->SetFocus();
		iRet = -1;
		goto END;
	}

	int iHoldTime = GetDlgItemInt(IDC_EDIT_STAYTIME);
	if(iHoldTime > MAX_HODE_TIME_EX || iHoldTime < MIN_HODE_TIME)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_HOLDTIME),_T(""),MB_OK|MB_TOPMOST);
		GetDlgItem(IDC_EDIT_STAYTIME)->SetFocus();
		iRet = -1;
		goto END;
	}

	GetDlgItemText(IDC_COMBO_PROTOCOLTYPE,strDeviceType);
	GetDlgItemText(IDC_EDIT_PASSWORD,strPwd);

	iIndex = m_cboConnectMode.GetCurSel();
	alarmLS.iUseddns = m_cboConnectMode.GetItemData(iIndex);
	iIndex = m_cboDevPlatType.GetCurSel();
	iDevType = m_cboDevPlatType.GetItemData(iIndex);
	alarmLS.iSerType = iDevType;
	if (DEVTYPE_RTSP == alarmLS.iSerType)
	{
		strcpy_s(alarmLS.cRtspUrl, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
	}
	else
	{
		if (0 != alarmLS.iUseddns)
		{
			strcpy_s(alarmLS.cSerName, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
		}
		else
		{
			strcpy_s(alarmLS.cSerIP, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
		}
	}

	strcpy_s(alarmLS.cSerProxy,strProxyIP.GetLength()+1,(LPCSTR)(LPCTSTR)strProxyIP);
	strcpy_s(alarmLS.cUserName,strUser.GetLength()+1,(LPCSTR)(LPCTSTR)strUser);
	strcpy_s(alarmLS.cPassword,strPwd.GetLength()+1,(LPCSTR)(LPCTSTR)strPwd);
	alarmLS.iSerChan = m_cboChannel.GetCurSel();
	alarmLS.iSerStreamNo = m_cboStream.GetCurSel();
	alarmLS.iSerNetmode = m_cboNetMode.GetCurSel()+1;

	alarmLS.iSerPort = iPort;
	alarmLS.iPortNo = m_iPort;
	alarmLS.iHoldTime = iHoldTime;

	GetDlgItemText(IDC_EDIT_ENCYPTPWD, strEncyptPWD);
	strcpy_s(alarmLS.cEncrypt, (LPCSTR)(LPCTSTR)strEncyptPWD);

	alarmLS.iAlarmType = m_iAlarmType;//

	iIndex = m_cboChannelNum.GetCurSel();
	alarmLS.iChannelNo = m_cboChannelNum.GetItemData(iIndex);

	iIndex = m_cboPicNO.GetCurSel();
	alarmLS.iPos = m_cboPicNO.GetItemData(iIndex);

	alarmLS.iLinkSwitchEnable = ALARM_LINK_SWITCH_ENBALE;

	iRet = DEC_ClientSetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &alarmLS, sizeof(AlarmLinkSwitch));
	if (iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[DEC_ClientSetDevConfig::CMD_DEC_CFG_ALARM_LINK_SWITCH]Failed!");
	}

END:
	return iRet;
}

int CNvsInfo::ProcessVideoServerInfo()
{
	int iRet = -1;
	CString strServerIP,strProxyIP,strDeviceType,strUser,strPwd;
	CString strEncyptPWD;
	CString cstrMultIp;
	if (m_ptViewServer == NULL)
	{
		AddLog(LOG_LEVEL_WARN,"[CNvsInfo::ProcessVideoServerInfo] m_ptViewServer is null!");
		goto END;
	}

	int iConnectMode = m_cboConnectMode.GetCurSel();
	GetDlgItemText(IDC_EDIT_SERVER_IP,strServerIP);//--------------->>ȡServerIP
	strServerIP = strServerIP.Trim();

	int iIndex = m_cboDevPlatType.GetCurSel();
	int iDevType = m_cboDevPlatType.GetItemData(iIndex);
	if (iDevType != DEVTYPE_ENCODE && iDevType != DEVTYPE_RTSP && DEVTYPE_LOCAL != DEVTYPE_LOCAL)		//RTSP
	{
		iRet = CheckInvalidIp(iConnectMode, strServerIP);
		if (iRet < 0)
		{
			goto END;
		}
	}

	GetDlgItemText(IDC_EDIT_PROXY_IP,strProxyIP);
	strProxyIP = strProxyIP.Trim();

	int iPort = GetDlgItemInt(IDC_EDIT_PORT);
	
	int iAddress = GetDlgItemInt(IDC_EDIT_ADDRESS);
	iAddress -= 1;

	GetDlgItemText(IDC_EDIT_USERNAME,strUser);
	strUser = strUser.Trim();

	int iHoldTime = GetDlgItemInt(IDC_EDIT_STAYTIME);
	if(iHoldTime > MAX_HODE_TIME || iHoldTime < MIN_HODE_TIME)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_HOLDTIME),_T(""),MB_OK|MB_TOPMOST);
		GetDlgItem(IDC_EDIT_STAYTIME)->SetFocus();
		iRet = -1;
		goto END;
	}

	GetDlgItemText(IDC_COMBO_PROTOCOLTYPE,strDeviceType);
	GetDlgItemText(IDC_EDIT_PASSWORD,strPwd);

	if (iDevType != DEVTYPE_ENCODE)
	{
		if (!strProxyIP.IsEmpty() && IsValidIP((LPSTR)(LPCTSTR)strProxyIP) != 1)
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_PROXY_IP),_T(""),MB_OK|MB_TOPMOST);
			GetDlgItem(IDC_EDIT_PROXY_IP)->SetFocus();
			iRet = -1;
			goto END;
		}

		if((iPort < MIN_SERVER_PORT) || (iPort > MAX_SERVER_PORT))
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_PORT),_T(""),MB_OK|MB_TOPMOST);
			GetDlgItem(IDC_EDIT_PORT)->SetFocus();
			iRet = -1;
			goto END;
		}

		if((iAddress < 0) || (iAddress > 256))
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_ADDRESS),_T(""),MB_OK|MB_TOPMOST);
			GetDlgItem(IDC_EDIT_ADDRESS)->SetFocus();
			iRet = -1;
			goto END;
		}

		if (strUser.IsEmpty())
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_USERNAME),_T(""),MB_OK|MB_TOPMOST);
			GetDlgItem(IDC_EDIT_USERNAME)->SetFocus();
			iRet = -1;
			goto END;
		}
	}

	m_ptViewServer->con_mode = m_cboConnectMode.GetCurSel();

	if (DEVTYPE_RTSP == iDevType)		//RTSPserName
	{
		strcpy_s(m_ptViewServer->rtsp_url, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
	}
	else
	{
		if (0 != m_ptViewServer->con_mode)
			strcpy_s(m_ptViewServer->ser_name, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
		else
			strcpy_s(m_ptViewServer->ser_ip, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
	}

	strcpy_s(m_ptViewServer->ser_proxy,strProxyIP.GetLength()+1,(LPCSTR)(LPCTSTR)strProxyIP);
	strcpy_s(m_ptViewServer->ser_ptz_protocol,strDeviceType.GetLength()+1,(LPCSTR)(LPCTSTR)strDeviceType);
	strcpy_s(m_ptViewServer->ser_usr_name,strUser.GetLength()+1,(LPCSTR)(LPCTSTR)strUser);
	strcpy_s(m_ptViewServer->ser_usr_pwd,strPwd.GetLength()+1,(LPCSTR)(LPCTSTR)strPwd);
	m_ptViewServer->ser_ch_no = m_cboChannel.GetCurSel();
	m_ptViewServer->ser_stream_no = m_cboStream.GetCurSel();
	m_ptViewServer->ser_net_mode = m_cboNetMode.GetCurSel()+1;		//TCP/UDP

	m_ptViewServer->ser_port = iPort;
	m_ptViewServer->ser_ptz_addr = iAddress;
	m_ptViewServer->hold_time = iHoldTime;

	GetDlgItemText(IDC_EDIT_ENCYPTPWD, strEncyptPWD);
	strcpy_s(m_ptViewServer->video_dec_pwd, (LPCSTR)(LPCTSTR)strEncyptPWD);

	iIndex = m_cboDevPlatType.GetCurSel();
	iDevType = m_cboDevPlatType.GetItemData(iIndex);
	m_ptViewServer->ser_type = iDevType;

	GetDlgItemText(IDC_EDIT_NVSINFO_MULTIP, cstrMultIp);
	strcpy_s(m_ptViewServer->mult_ip, (LPCSTR)(LPCTSTR)cstrMultIp);
	int iMultPort = 0;
	iMultPort = GetDlgItemInt(IDC_EDIT_NVSINFO_MULTPORT);
	m_ptViewServer->mult_port = iMultPort;

	iRet = 0;

END:
	return iRet;
}

void CNvsInfo::OnCbnSelchangeComboDevplattype()
{
	if (DEVTYPE_ONVIF == m_cboDevPlatType.GetCurSel() || DEVTYPE_LG == m_cboDevPlatType.GetCurSel() || DEVTYPE_PANASONIC == m_cboDevPlatType.GetCurSel())
	{
		SetDlgItemInt(IDC_EDIT_PORT, CONST_INT_ONVIF_PORT);
	}
	else
	{
		SetDlgItemInt(IDC_EDIT_PORT, CONST_INT_NORMAL_PORT);
	}
}
